#!/bin/sh

# QLogic ISP2xxx device driver build script
# Copyright (C) 2003-2004 QLogic Corporation
# (www.qlogic.com)
# 
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any
# later version.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#

Q_NODE=QLA2XXX
Q_CONF_FILE=/etc/qla2xxx.conf

UNAME=`uname -a`
K_VERSION=`uname -r`
K_LIBS=/lib/modules/${K_VERSION}
K_BUILD_DIR=${K_LIBS}/build
K_SOURCE_DIR=${K_LIBS}/source
K_INSTALL_DIR=${K_LIBS}/kernel/drivers/scsi/qla2xxx/
K_THREADS=5

SLES=/etc/SuSE-release
SLES_CONF=/etc/sysconfig/kernel
SLES_CONF_KEY=INITRD_MODULES
RHEL=/etc/redhat-release

SLES_MPC=/etc/modprobe.conf.local
RHEL_MPC=/etc/modprobe.conf

###
# drv_build -- Generic 'make' command for driver
#	$1 -- directive
#
drv_build() {
	test -z "$1" && return 1

	# Go with build...
	if test -f "${SLES}" ; then
		# SuSE -------------------------------------------------------
		make -j${K_THREADS} -C ${K_SOURCE_DIR} O=${K_BUILD_DIR} M=$PWD $1
	else
		# Redhat -----------------------------------------------------
		make -j${K_THREADS} -C ${K_BUILD_DIR} M=$PWD $1
	fi
}

###
# drv_install -- Generic steps for installation
#
drv_install() {
	if test $EUID -ne 0 ; then
		echo "${Q_NODE} -- Must be root to install..."
		return 1
	fi

	echo "${Q_NODE} -- Installing the qla2xxx modules to ${K_INSTALL_DIR}..."
	install -d -o root -g root ${K_INSTALL_DIR}
	install -o root -g root -m 0644 *.ko ${K_INSTALL_DIR}

	# Post-remove of qla2xxx_conf module
	if test -f "${SLES}" ; then
		MPC=${SLES_MPC}
	else
		MPC=${RHEL_MPC}
	fi
	if [ `grep -c "remove qla2xxx" ${MPC}` -eq 0 ]
	then
		echo "remove qla2xxx /sbin/modprobe -r --first-time --ignore-remove qla2xxx && { /sbin/modprobe -r --ignore-remove qla2xxx_conf; }" >> ${MPC}
	fi

	# Update any existing qla2xxx_conf data
	if test -f "${Q_CONF_FILE}" ; then
		echo "${Q_NODE} -- Updating the qla2xx_conf module..."
		./extras/qla_opts -w qla2xxx_conf
	fi
	# depmod
	/sbin/depmod -a
}

###
#
#
case "$1" in
    help)
	echo "QLogic Corporation -- qla2xxx build script"
	echo "  build.sh <directive>"
	echo ""
	echo "   # cd <driver source>"
	echo "   # ./extras/build.sh"
	echo ""
	echo "    Build the driver sources based on the standard SLES9/RHEL4"
	echo "    build environment."
	echo ""
	echo "   # ./extras/build.sh clean"
	echo ""
	echo "    Clean driver source directory of all build files (i.e. "
	echo "    *.ko, *.o, etc)."
	echo ""
	echo "   # ./extras/build.sh new"
	echo ""
	echo "    Rebuild the driver sources from scratch."
	echo "    This is essentially a shortcut for:"
	echo ""
	echo "        # ./build.sh clean"
	echo "        # ./build.sh"
	echo ""
	echo "   # ./extras/build.sh install"
	echo ""
	echo "     Build and install the driver module files."
	echo "     This command performs the following:"
	echo ""
	echo "        1. Builds the driver .ko files."
	echo "        2. Copies the .ko files to the appropriate "
	echo "           /lib/modules/... directory."
	echo "        3. Adds the appropriate directive in the "
	echo "           modprobe.conf[.local] to remove the qla2xxx_conf "
	echo "           module when the qla2xxx modules in unloaded."
	echo "        4. Updates the newly built qla2xxx_conf.ko module with "
	echo "           any previously saved data in /etc/qla2xxx.conf."
	echo ""
	echo "   # ./extras/build.sh initrd"
	echo ""
	echo "     Build, install, and update the initrd image."
	echo "     This command performs the following:"
	echo ""
	echo "        1. All steps in the 'install' directive."
	echo "        2. Adds an qla2xxx_conf entry into the "
	echo "           /etc/sysconfig/kernel INITRD_MODULES if and only if a"
	echo "           qla2xxx module already is present in the listing."
	echo "        3. Rebuilds the initrd image with the /sbin/mk_initrd"
        echo "           command."
	echo ""
	echo "     NOTE: One should insure that the the additional qla2xxx_conf"
        echo "           module is appropriately added after initiating this"
	echo "           directive.  The script is coded to use do its 'best'"
	echo "           at insuring the entry is placed in the proper order."
	;;
    install)
	# QLA2XXX Specific
	echo "${Q_NODE} -- Building the qla2xxx driver..."
	drv_build modules

	drv_install
	;;
    initrd)
	# QLA2XXX Specific
	echo "${Q_NODE} -- Building the qla2xxx driver..."
	drv_build modules

	drv_install

	# Any distribution specific steps
	if test -f "${SLES}" ; then
		# SuSE -------------------------------------------------------
		echo "${Q_NODE} -- Updating SLES stuffs ${SLES_CONF}..."
		if [ `grep -c "^INITRD_MODULES.*qla" ${SLES_CONF}` -ne 0 ]
		then
			echo "${Q_NODE} -- Found QLA driver in ${SLES_CONF}..."
			if [ `grep -c "^INITRD_MODULES.*qla2xxx_conf" ${SLES_CONF}` -eq 0 ]; then
				echo "${Q_NODE} -- Adding qla2xxx_conf to module list..."
				cp --archive ${SLES_CONF} ${SLES_CONF}.orig
				sed -e 's/INITRD_MODULES=\"\(.*\)\"/INITRD_MODULES=\"qla2xxx_conf \1\"/' ${SLES_CONF}.orig > ${SLES_CONF}
			fi
		fi
		echo "${Q_NODE} -- Rebuilding INITRD image..."
		/sbin/mk_initrd
	fi
	;;
    clean)
	echo "${Q_NODE} -- Cleaning driver build directory..."
	drv_build clean
	;;
    new)
	echo "${Q_NODE} -- Clean rebuild of the qla2xxx driver..."
	drv_build clean
	drv_build modules
	;;
    *)
	echo "${Q_NODE} -- Building the qla2xxx driver..."
	drv_build modules
	;;
esac
